/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.data.mongo.repository;

import cn.ziyicloud.framework.boot.autoconfigure.data.core.domain.SelfRelevance;
import cn.ziyicloud.framework.boot.autoconfigure.data.mongo.repository.BaseMongoRepository;
import cn.ziyicloud.framework.boot.enums.ErrorCodeEnum;
import cn.ziyicloud.framework.boot.exception.BaseException;
import cn.ziyicloud.framework.boot.util.ObjectUtils;
import cn.ziyicloud.framework.boot.util.conlection.CollectionUtils;
import java.util.Collection;
import java.util.List;

public interface SelfRelevanceMongoRepository<T extends SelfRelevance<ID>, ID>
extends BaseMongoRepository<T, ID> {
    public List<T> findByIdIn(Iterable<ID> var1);

    public boolean existsByPid(ID var1);

    public List<T> findByPid(ID var1);

    public List<T> findByPidIn(Iterable<ID> var1);

    default public void checkPid(ID pid, ID id, ID rootId) {
        boolean exists;
        boolean bl = exists = null == pid || rootId == pid || this.existsById(pid);
        if (!exists) {
            throw new BaseException(ErrorCodeEnum.PID_NOT_EXIST);
        }
        if (id != null && id.equals(pid)) {
            throw new BaseException(ErrorCodeEnum.PID_IS_SELF);
        }
    }

    default public List<T> getAllSub(Collection<ID> ids, List<T> childrenList) {
        List<T> children = this.findByPidIn(ids);
        if (children.isEmpty()) {
            return childrenList;
        }
        ids = ObjectUtils.getIds(children);
        ids = CollectionUtils.subtractions((Collection)ids, (Collection)ObjectUtils.getIds(childrenList));
        childrenList.addAll(children);
        childrenList = ObjectUtils.distinctById(childrenList);
        return this.getAllSub(ids, childrenList);
    }

    default public List<T> getAllParent(Collection<ID> pids, List<T> parentList) {
        List<T> parent = this.findByIdIn(pids);
        if (parent.isEmpty()) {
            return parentList;
        }
        pids = ObjectUtils.getPids(parent);
        pids = CollectionUtils.subtractions((Collection)pids, (Collection)ObjectUtils.getPids(parentList));
        parentList.addAll(parent);
        parentList = ObjectUtils.distinctById(parentList);
        return this.getAllParent(pids, parentList);
    }
}

