/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.data.redis;

import cn.ziyicloud.framework.boot.exception.BaseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;

public class RedisUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisUtils.class);
    private static int DEFAULT_DB_INDEX;
    private static RedisTemplate<String, Object> redisTemplate;

    public static void init(RedisTemplate<String, Object> template, int defaultDbIndex) {
        redisTemplate = template;
        DEFAULT_DB_INDEX = defaultDbIndex;
    }

    public static void setDatabase(Integer index) {
        LettuceConnectionFactory redisConnectionFactory = (LettuceConnectionFactory)redisTemplate.getConnectionFactory();
        assert (redisConnectionFactory != null);
        redisConnectionFactory.setDatabase(index.intValue());
        redisConnectionFactory.afterPropertiesSet();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)redisConnectionFactory);
        redisConnectionFactory.resetConnection();
    }

    public static void resetDatabase() {
        RedisUtils.setDatabase(DEFAULT_DB_INDEX);
    }

    public static boolean expire(String key, long time) {
        return RedisUtils.expire(key, time, TimeUnit.SECONDS);
    }

    public static boolean expire(String key, long time, TimeUnit timeUnit) {
        try {
            if (time > 0L) {
                redisTemplate.expire((Object)key, time, timeUnit);
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public static long getExpire(String key) {
        return redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public static boolean hasKey(String key) {
        try {
            return redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static void del(String key) {
        redisTemplate.delete((Object)key);
    }

    public static void del(Collection<String> keys) {
        redisTemplate.delete(keys);
    }

    public static List<String> scan(String pattern) {
        ScanOptions options = ScanOptions.scanOptions().match(pattern).build();
        RedisConnectionFactory factory = redisTemplate.getConnectionFactory();
        RedisConnection rc = factory.getConnection();
        Cursor cursor = rc.scan(options);
        ArrayList<String> result = new ArrayList<String>();
        while (cursor.hasNext()) {
            result.add(new String((byte[])cursor.next()));
        }
        try {
            RedisConnectionUtils.releaseConnection((RedisConnection)rc, (RedisConnectionFactory)factory);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<String> findKeysForPage(String patternKey, int page, int size) {
        ScanOptions options = ScanOptions.scanOptions().match(patternKey).build();
        RedisConnectionFactory factory = redisTemplate.getConnectionFactory();
        RedisConnection rc = factory.getConnection();
        Cursor cursor = rc.scan(options);
        ArrayList<String> result = new ArrayList<String>(size);
        int tmpIndex = 0;
        int fromIndex = page * size;
        int toIndex = page * size + size;
        while (cursor.hasNext()) {
            if (tmpIndex >= fromIndex && tmpIndex < toIndex) {
                result.add(new String((byte[])cursor.next()));
                ++tmpIndex;
                continue;
            }
            if (tmpIndex >= toIndex) break;
            ++tmpIndex;
            cursor.next();
        }
        try {
            RedisConnectionUtils.releaseConnection((RedisConnection)rc, (RedisConnectionFactory)factory);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static Object get(String key) {
        return key == null ? null : redisTemplate.opsForValue().get((Object)key);
    }

    public List<Object> multiGet(List<String> keys) {
        return redisTemplate.opsForValue().multiGet(keys);
    }

    public static boolean set(String key, Object value) {
        try {
            redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                RedisUtils.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean set(String key, Object value, long time, TimeUnit timeUnit) {
        try {
            if (time > 0L) {
                redisTemplate.opsForValue().set((Object)key, value, time, timeUnit);
            } else {
                RedisUtils.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static long incr(String key, long delta) {
        if (delta < 0L) {
            throw new BaseException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public static long decr(String key, long delta) {
        if (delta < 0L) {
            throw new BaseException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public static Object hget(String key, String item) {
        if (key == null || item == null) {
            return null;
        }
        return redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public static Map<Object, Object> hmget(String key) {
        return key == null ? null : redisTemplate.opsForHash().entries((Object)key);
    }

    public static boolean hmset(String key, Map<String, Object> map) {
        try {
            redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean hmset(String key, Map<String, ?> map, long time) {
        try {
            redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                RedisUtils.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean hset(String key, String item, Object value) {
        try {
            redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean hset(String key, String item, Object value, long time) {
        try {
            redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                RedisUtils.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static void hdel(String key, Object ... item) {
        redisTemplate.opsForHash().delete((Object)key, item);
    }

    public static boolean hHasKey(String key, String item) {
        if (key == null || item == null) {
            return false;
        }
        return redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public static Long hincr(String key, String item, long by) {
        return redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public static Long hdecr(String key, String item, long by) {
        return redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public static Set<Object> sGet(String key) {
        try {
            return redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean sHasKey(String key, Object value) {
        try {
            return redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static long sSet(String key, Object ... values) {
        try {
            return redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static long sSetAndTime(String key, long time, Object ... values) {
        try {
            Long count = redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                RedisUtils.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static long sGetSetSize(String key) {
        try {
            return redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static long setRemove(String key, Object ... values) {
        try {
            return redisTemplate.opsForSet().remove((Object)key, values);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static List<Object> lGet(String key, long start, long end) {
        try {
            return redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return new ArrayList<Object>();
        }
    }

    public static List<Object> lGet(String key) {
        return RedisUtils.lGet(key, 0L, -1L);
    }

    public static long lGetListSize(String key) {
        try {
            return redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static Object lGetIndex(String key, long index) {
        try {
            return redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean lSet(String key, Object value) {
        try {
            redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean lSet(String key, Object value, long time) {
        try {
            redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                RedisUtils.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean lSet(String key, List<Object> value) {
        try {
            redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean lSet(String key, List<Object> value, long time) {
        try {
            redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                RedisUtils.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean lUpdateIndex(String key, long index, Object value) {
        try {
            redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static long lRemove(String key, long count, Object value) {
        try {
            return redisTemplate.opsForList().remove((Object)key, count, value);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }
}

