/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.doc.springdoc;

import cn.ziyicloud.framework.boot.autoconfigure.doc.core.InterceptorUtils;
import cn.ziyicloud.framework.boot.autoconfigure.doc.core.ZiyiApiInfo;
import cn.ziyicloud.framework.boot.autoconfigure.doc.core.ZiyiContact;
import cn.ziyicloud.framework.boot.autoconfigure.doc.core.ZiyiLicense;
import cn.ziyicloud.framework.boot.autoconfigure.doc.core.ZiyiSwaggerProperties;
import cn.ziyicloud.framework.boot.autoconfigure.doc.springdoc.ZiyiSpringdocProperties;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.webmvc.core.SpringDocWebMvcConfiguration;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={ZiyiSpringdocProperties.class, ZiyiSwaggerProperties.class})
@ConditionalOnClass(value={SpringDocWebMvcConfiguration.class})
public class ZiyiSpringdocAutoConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(ZiyiSpringdocAutoConfiguration.class);
    private final BeanFactory beanFactory;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"ziyi.doc.swagger.auto"}, havingValue="true", matchIfMissing=true)
    public OpenAPI ziyiOpenApi(ZiyiSwaggerProperties swaggerProperties) {
        return new OpenAPI().info(this.getInfo(swaggerProperties.getApiInfo()));
    }

    public void addInterceptors(@Nonnull InterceptorRegistry registry) {
        InterceptorUtils.excludeSwagger(registry);
    }

    private Info getInfo(ZiyiApiInfo apiInfo) {
        return new Info().title(apiInfo.getTitle()).description(apiInfo.getDescription()).version(apiInfo.getVersion()).contact(this.getContact(apiInfo.getContact())).license(this.getLicense(apiInfo.getLicense())).extensions(apiInfo.getExtensions());
    }

    private Contact getContact(ZiyiContact contact) {
        return new Contact().name(contact.getName()).url(contact.getUrl()).email(contact.getEmail()).extensions(contact.getExtensions());
    }

    private License getLicense(ZiyiLicense license) {
        return new License();
    }

    public ZiyiSpringdocAutoConfiguration(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

