/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.doc.springfox;

import cn.ziyicloud.framework.boot.autoconfigure.doc.core.InterceptorUtils;
import cn.ziyicloud.framework.boot.autoconfigure.doc.core.ZiyiApiInfo;
import cn.ziyicloud.framework.boot.autoconfigure.doc.core.ZiyiSwaggerProperties;
import cn.ziyicloud.framework.boot.autoconfigure.doc.springfox.ZiyiSpringfoxProperties;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import com.github.xiaoymin.knife4j.spring.filter.ProductionSecurityFilter;
import com.github.xiaoymin.knife4j.spring.filter.SecurityBasicAuthFilter;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.configuration.Swagger2DocumentationWebMvcConfiguration;

@Configuration
@EnableConfigurationProperties(value={ZiyiSpringfoxProperties.class, ZiyiSwaggerProperties.class})
@ConditionalOnClass(value={Swagger2DocumentationWebMvcConfiguration.class})
@Import(value={Swagger2DocumentationWebMvcConfiguration.class})
@ComponentScan(basePackages={"com.github.xiaoymin.knife4j.spring.plugin"})
public class ZiyiSpringfoxAutoConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(ZiyiSpringfoxAutoConfiguration.class);
    private final BeanFactory beanFactory;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"ziyi.doc.swagger.auto"}, havingValue="true", matchIfMissing=true)
    public Docket ziyiApi(ZiyiSpringfoxProperties knife4jProperties, ZiyiSwaggerProperties swaggerProperties) {
        String basePackage = swaggerProperties.getBasePackage();
        if (StringUtils.isBlank((CharSequence)basePackage)) {
            basePackage = (String)AutoConfigurationPackages.get((BeanFactory)this.beanFactory).get(0);
        }
        return new Docket(DocumentationType.SWAGGER_2).host(swaggerProperties.getHost()).groupName(swaggerProperties.getGroupName()).apiInfo(this.getApiInfo(swaggerProperties.getApiInfo())).select().apis(RequestHandlerSelectors.basePackage((String)basePackage)).paths(PathSelectors.any()).build().extensions(knife4jProperties.getExtensionResolver().buildExtensions(swaggerProperties.getGroupName()));
    }

    @Bean(value={"ziyiKnife4jCorsFilter"})
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"ziyi.doc.knife4j.cors"}, havingValue="true")
    public CorsFilter corsFilter() {
        log.info("init ziyiKnife4jCorsFilter...");
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.setAllowCredentials(Boolean.valueOf(true));
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        corsConfiguration.setMaxAge(Long.valueOf(10000L));
        source.registerCorsConfiguration("/**", corsConfiguration);
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean(initMethod="start", value={"ziyiKnife4jOpenApiExtensionResolver"})
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"ziyi.doc.knife4j.enabled"}, havingValue="true")
    public OpenApiExtensionResolver markdownResolver(ZiyiSpringfoxProperties knife4jProperties) {
        return knife4jProperties.getExtensionResolver();
    }

    @Bean(value={"ziyiKnife4jSecurityBasicAuthFilter"})
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"ziyi.doc.knife4j.basic.enabled"}, havingValue="true")
    public SecurityBasicAuthFilter securityBasicAuthFilter(ZiyiSpringfoxProperties knife4jProperties) {
        return knife4jProperties.getBasic().getAuthFilter();
    }

    @Bean(value={"ziyiKnife4jProductionSecurityFilter"})
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"ziyi.doc.knife4j.production"}, havingValue="true")
    public ProductionSecurityFilter productionSecurityFilter(ZiyiSpringfoxProperties knife4jProperties) {
        return new ProductionSecurityFilter(knife4jProperties.isProduction());
    }

    public void addInterceptors(@Nonnull InterceptorRegistry registry) {
        InterceptorUtils.excludeSwagger(registry);
    }

    private ApiInfo getApiInfo(ZiyiApiInfo apiInfo) {
        return new ApiInfoBuilder().title(apiInfo.getTitle()).description(apiInfo.getDescription()).version(apiInfo.getVersion()).termsOfServiceUrl(apiInfo.getTermsOfServiceUrl()).contact(new Contact(apiInfo.getContact().getName(), apiInfo.getContact().getUrl(), apiInfo.getContact().getEmail())).license(apiInfo.getLicense().getName()).licenseUrl(apiInfo.getLicense().getUrl()).build();
    }

    public ZiyiSpringfoxAutoConfiguration(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

