/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.fastjson.filter;

import cn.ziyicloud.framework.boot.autoconfigure.fastjson.filter.annotation.ValueHide;
import cn.ziyicloud.framework.boot.util.reflect.ReflectUtils;
import com.alibaba.fastjson.serializer.ValueFilter;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueHideFilter
implements ValueFilter {
    private static final Logger log = LoggerFactory.getLogger(ValueHideFilter.class);

    public Object process(Object object, String name, Object value) {
        if (value != null) {
            try {
                Field field = ReflectUtils.getField((Object)object, (String)name);
                if (field.isAnnotationPresent(ValueHide.class)) {
                    ValueHide valueHide = field.getDeclaredAnnotation(ValueHide.class);
                    if (valueHide.length() <= 0) {
                        return object;
                    }
                    String fieldValue = String.valueOf(value);
                    char[] chars = fieldValue.toCharArray();
                    if (valueHide.start() > 0) {
                        return this.hide(valueHide, chars);
                    }
                    return this.positionHide(valueHide, chars);
                }
            }
            catch (Exception e) {
                log.debug("\u6570\u503c\u9690\u85cf\u51fa\u9519", (Throwable)e);
            }
        }
        return value;
    }

    private String hide(ValueHide valueHide, char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (valueHide.start() - 1 > i || i >= valueHide.start() + valueHide.length() - 1) continue;
            chars[i] = valueHide.placeholder();
        }
        return new String(chars);
    }

    private String positionHide(ValueHide valueHide, char[] chars) {
        int startPosition = chars.length / 2;
        int hideLength = valueHide.length();
        char placeholder = valueHide.placeholder();
        for (int i = 0; i < chars.length; ++i) {
            boolean hide = i >= startPosition - 1 && i < startPosition - 1 + hideLength;
            switch (valueHide.position()) {
                case START: {
                    hide = i < hideLength;
                    break;
                }
                case END: {
                    hide = i >= chars.length - hideLength;
                    break;
                }
            }
            if (!hide) continue;
            chars[i] = placeholder;
        }
        return new String(chars);
    }
}

