/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.web.handler;

import cn.ziyicloud.framework.boot.enums.ErrorCodeEnum;
import cn.ziyicloud.framework.boot.exception.BaseException;
import cn.ziyicloud.framework.boot.model.BaseResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=1)
public class ZiyiExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ZiyiExceptionHandler.class);

    @ExceptionHandler(value={BaseException.class})
    public BaseResponse exceptionHandler(BaseException e) {
        this.debugLog((Exception)e);
        return new BaseResponse(e);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public BaseResponse exceptionHandler(HttpMessageNotReadableException e) {
        this.debugLog((Exception)e);
        return new BaseResponse(new BaseException(ErrorCodeEnum.BAD_REQUEST, e.getMessage(), (Throwable)e));
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public BaseResponse exceptionHandler(HttpRequestMethodNotSupportedException e) {
        this.debugLog((Exception)e);
        return new BaseResponse(new BaseException(ErrorCodeEnum.METHOD_NOT_SUPPORTED, (Throwable)e));
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public BaseResponse exceptionHandler(HttpMediaTypeNotSupportedException e) {
        this.debugLog((Exception)e);
        return new BaseResponse(new BaseException(ErrorCodeEnum.MEDIA_TYPE_NOT_SUPPORTED, (Throwable)e));
    }

    @ExceptionHandler(value={BindException.class})
    public BaseResponse exceptionHandler(BindException e) {
        this.debugLog((Exception)e);
        List objectErrors = e.getBindingResult().getAllErrors();
        return this.getValidExceptionResult(objectErrors);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public BaseResponse exceptionHandler(MethodArgumentNotValidException e) {
        this.debugLog((Exception)e);
        List objectErrors = e.getBindingResult().getAllErrors();
        return this.getValidExceptionResult(objectErrors);
    }

    @ExceptionHandler(value={Exception.class})
    public BaseResponse exceptionHandler(Exception e) {
        this.debugLog(e);
        return new BaseResponse(new BaseException(ErrorCodeEnum.BAD_REQUEST, e.getMessage(), (Throwable)e));
    }

    private BaseResponse getValidExceptionResult(List<ObjectError> objectErrors) {
        StringBuilder sb = new StringBuilder();
        for (ObjectError error : objectErrors) {
            sb.append(error.getDefaultMessage()).append(";");
        }
        String message = sb.length() > 0 ? sb.toString().substring(0, sb.length() - 1) : sb.toString();
        return new BaseResponse(ErrorCodeEnum.PARAMETER_NOT_SUPPORTED, message);
    }

    private void debugLog(Exception e) {
        if (log.isDebugEnabled()) {
            log.debug("\u54cd\u5e94\u5f02\u5e38", (Throwable)e);
        }
    }
}

