/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.web.handler;

import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.ziyicloud.framework.boot.autoconfigure.web.ZiyiWebProperties;
import cn.ziyicloud.framework.boot.autoconfigure.web.annotation.ZiyiRSAEncrypt;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.AnnotatedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
@Order(value=2)
public class ZiyiRSAEncryptHandler
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(ZiyiRSAEncryptHandler.class);
    private ZiyiWebProperties.RsaInfo rsaInfo;
    private RSA rsa;
    private ObjectMapper objectMapper = new ObjectMapper();

    public ZiyiRSAEncryptHandler(ZiyiWebProperties webProperties) {
        this.rsaInfo = webProperties.getRsa();
        this.rsa = new RSA(webProperties.getRsa().getPrivateKey(), webProperties.getRsa().getPublicKey());
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        if (!this.rsaInfo.isOpen()) {
            return false;
        }
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)returnType.getContainingClass(), ZiyiRSAEncrypt.class) || returnType.hasMethodAnnotation(ZiyiRSAEncrypt.class);
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        String privateKey = this.rsaInfo.getPrivateKey();
        try {
            String content = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(body);
            return this.rsa.encryptBcd(content, KeyType.PublicKey);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u6570\u636e\u5f02\u5e38", (Throwable)e);
            return body;
        }
    }
}

