package cn.ziyicloud.framework.boot.sample.fastjson;

import cn.ziyicloud.framework.boot.util.reflect.ReflectUtils;
import com.alibaba.fastjson.serializer.ValueFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

import java.lang.reflect.Field;
import java.math.BigDecimal;

/**
 * 对应BigDecimalFormatter注解的ValueFilter实现
 *
 * @author Li Ruitong
 * @date 2020/5/15
 */
public class BigDecimalValueFilter implements ValueFilter {
    /**
     * logback
     */
    Logger logger = LoggerFactory.getLogger(BigDecimalValueFilter.class);

    /**
     * @param object 对象
     * @param name   对象的字段的名称
     * @param value  对象的字段的值
     */
    @Override
    public Object process(Object object, String name, Object value) {
        if (ObjectUtils.isEmpty(value) || !(value instanceof BigDecimal)) {
            return value;
        }
        return convertValue(object, name, value);
    }

    /**
     * 转换值
     *
     * @param object 字段所属对象实例
     * @param name   字段名称
     * @param value  字段的值
     * @return Object
     */
    Object convertValue(Object object, String name, Object value) {
        try {
            // 反射获取field
            Field field = ReflectUtils.getField(object, name);
            // 判断字段是否存在@BigDecimalFormatter注解
            if (field.isAnnotationPresent(BigDecimalFormatter.class)) {
                BigDecimalFormatter bigDecimalFormatter = field.getAnnotation(BigDecimalFormatter.class);
                // 执行格式化
                BigDecimal decimal = (BigDecimal) value;
                System.out.println(bigDecimalFormatter.scale());
                // 保留小数位数，删除多余
                value = decimal.setScale(bigDecimalFormatter.scale(), BigDecimal.ROUND_DOWN).doubleValue();
            }
        } catch (Exception e) {
            logger.error("格式化BigDecimal字段出现异常：{}", e.getMessage());
        }
        return value;
    }
}
