package cn.ziyicloud.framework.boot.sample.fastjson;

import cn.ziyicloud.framework.boot.annotation.AnonymousAccess;
import cn.ziyicloud.framework.boot.model.ZiyiDataResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;

/**
 * ZiyiBootHttpConverter sample application
 *
 * @author Li Ruitong
 * @date 2020/5/15
 */
@SpringBootApplication
@RestController
@Slf4j
public class ZiyiFastJsonHttpConverterSampleApplication {
    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(ZiyiFastJsonHttpConverterSampleApplication.class);
        Environment env = app.run(args).getEnvironment();
        log.info("「「「「Ziyi Boot Http Converter Sample Application 启动完成.」」」」」");
        System.out.println("项目地址: \t\thttp://localhost:" + env.getProperty("server.port") + "/json");
    }

    /**
     * 访问首页提示
     *
     * @return /
     */
    @GetMapping("/")
    @AnonymousAccess
    public String index() {
        return "Backend service started successfully";
    }

    @GetMapping(value = "/json")
    public ZiyiDataResponse<SampleEntity> jsonResult() {
        SampleEntity sampleEntity = new SampleEntity();
        sampleEntity.setDecimalValue(new BigDecimal("23.5599"));
        sampleEntity.setCodePhose("13900540213");
        return new ZiyiDataResponse<>(sampleEntity);
    }
}
