/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.sample.fastjson;

import cn.ziyicloud.framework.boot.annotation.AnonymousAccess;
import cn.ziyicloud.framework.boot.model.ZiyiDataResponse;
import cn.ziyicloud.framework.boot.sample.fastjson.SampleEntity;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@SpringBootApplication
@RestController
public class ZiyiFastJsonHttpConverterSampleApplication {
    private static final Logger log = LoggerFactory.getLogger(ZiyiFastJsonHttpConverterSampleApplication.class);

    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(new Class[]{ZiyiFastJsonHttpConverterSampleApplication.class});
        ConfigurableEnvironment env = app.run(args).getEnvironment();
        log.info("\u300c\u300c\u300c\u300cZiyi Boot Http Converter Sample Application \u542f\u52a8\u5b8c\u6210.\u300d\u300d\u300d\u300d\u300d");
        System.out.println("\u9879\u76ee\u5730\u5740: \t\thttp://localhost:" + env.getProperty("server.port") + "/json");
    }

    @GetMapping(value={"/"})
    @AnonymousAccess
    public String index() {
        return "Backend service started successfully";
    }

    @GetMapping(value={"/json"})
    public ZiyiDataResponse<SampleEntity> jsonResult() {
        SampleEntity sampleEntity = new SampleEntity();
        sampleEntity.setDecimalValue(new BigDecimal("23.5599"));
        sampleEntity.setCodePhose("13900540213");
        return new ZiyiDataResponse((Object)sampleEntity);
    }
}

