package cn.ziyicloud.framework.boot.sample.web;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Li Ruitong
 * @date 2020/5/26
 */
@RestController
@Api(tags = "测试")
@RequestMapping("/test")
public class SampleController {
    @ApiOperation("保存")
    @ApiOperationSupport(order = 1)
    @PostMapping
    public SampleModel save(@RequestBody SampleModel dto) {
        return dto;
    }

    @ApiOperation("删除")
    @ApiOperationSupport(order = 4)
    @DeleteMapping("/{id}")
    public void deleteById(@PathVariable long id) {
    }

    @ApiOperation("修改")
    @ApiOperationSupport(order = 2)
    @PutMapping
    public void udpate(@RequestBody SampleModel dto) {

    }

    @ApiOperation("查询")
    @ApiOperationSupport(order = 2)
    @GetMapping
    public List<SampleModel> getAll() {
        return new ArrayList<SampleModel>() {{
            add(new SampleModel("ziyi-boot-test1"));
            add(new SampleModel("ziyi-boot-test2"));
        }};
    }
}
