package cn.ziyicloud.framework.boot.sample.web;

import cn.ziyicloud.framework.boot.annotation.AnonymousAccess;
import cn.ziyicloud.framework.boot.autoconfigure.knife4j.annotation.EnableZiyiKnife4j;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Li Ruitong
 * @date 2020/5/26
 */
@RestController
@Slf4j
@SpringBootApplication
@EnableZiyiKnife4j
public class ZiyiWebSampleApplication {
    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(ZiyiWebSampleApplication.class);
        Environment env = app.run(args).getEnvironment();
        log.info("「「「「「 启动完成.」」」」」");
        System.out.println("文档路径: \t\thttp://localhost:" + env.getProperty("server.port") + "/doc.html");
    }

    /**
     * 访问首页提示
     *
     * @return /
     */
    @GetMapping("/")
    @AnonymousAccess
    public String index() {
        return "Backend service started successfully";
    }
}
