package cn.ziyicloud.framework.boot.enums;

/**
 * ERROR CODE ENUM
 *
 * @author Li Ruitong
 * @date 2020/5/15
 */
public enum ErrorCodeEnum {
    /**
     * 服务器异常
     */
    SERVER_ERROR(-1, "服务器异常，请稍后重试"),
    /**
     * 请求成功
     */
    SUCCESS(0, "ok"),
    /**
     * 数据层异常
     */
    DAO_ERROR(1, "数据处理出错"),
    /**
     * 业务层异常
     */
    SERVICE_ERROR(2, "业务处理出错"),
    /**
     * 调用第三方异常
     */
    MANAGER_ERROR(3, "调用第三方出错"),
    /**
     *
     */
    UTIL_ERROR(4, "调用工具方法出错"),
    /**
     *
     */
    HTTP_ERROR(5, "发送http请求出错"),
    /**
     * 请求错误
     */
    BAD_REQUEST(7001, "请求错误"),
    /**
     * 请求方法不支持
     */
    METHOD_NOT_SUPPORTED(7002, "请求方法不支持"),
    /**
     * 请求的Content-Type错误
     */
    MEDIA_TYPE_NOT_SUPPORTED(7003, "请求的Content-Type错误"),
    /**
     * 请求参数不符合规定
     */
    PARAMETER_NOT_SUPPORTED(7004, "请求参数不符合规定"),
    /**
     * id错误
     */
    ID_NOT_EXIST(70041, "资源不存在,请检查"),
    /**
     * 上级节点不存在，请检查pid
     */
    PID_NOT_EXIST(70042, "上级节点不存在，请检查"),

    /**
     * 上级节点不存在，请检查pid
     */
    PID_IS_SELF(70043, "上级不能是自己"),

    /**
     * 名字重复，请检查
     */
    NAME_REPEAT_ERROR(70044, "名字重复，请检查"),
    /**
     * 权限名重复，请检查
     */
    PERMISSION_REPEAT_ERROR(70045, "权限名重复，请检查"),
    /**
     * 未登录
     */
    UN_LOGIN(70051, "未登录"),
    /**
     * 没有权限
     */
    NO_PERMISSION(70052, "没有权限"),
    /**
     * 权限不足
     */
    LIMIT_PERMISSION(70053, "权限不足"),
    ;
    private Integer rtn;
    private String message;

    ErrorCodeEnum(Integer rtn, String message) {
        this.rtn = rtn;
        this.message = message;
    }

    public Integer getRtn() {
        return rtn;
    }

    public String getMessage() {
        return message;
    }
}
