package cn.ziyicloud.framework.boot.util.crypto;

import org.apache.commons.codec.digest.DigestUtils;

import java.util.Random;

/**
 * md5加密工具类
 *
 * @author Li Ruitong
 */
public class Md5Utils {

    /**
     * 返回md5加密小写字符
     *
     * @param source 源字符
     * @return md5加密后字符
     * @date 2019/7/1
     */
    public static String md5Hex(String source) {
        return DigestUtils.md5Hex(source);
    }

    /**
     * 生成含有随机盐的密码
     *
     * @param password 密码
     * @return 加盐后的字符串
     */
    public static String generatePassword(String password, String userName) {
        String salt = getSalt(userName);
        password = md5Hex(password + salt);
        char[] cs = new char[48];
        for (int i = 0; i < 48; i += 3) {
            cs[i] = password.charAt(i / 3 * 2);
            char c = salt.charAt(i / 3);
            cs[i + 1] = c;
            cs[i + 2] = password.charAt(i / 3 * 2 + 1);
        }
        return new String(cs);
    }

    /**
     * 校验密码是否正确
     *
     * @param password 密码
     * @param md5      加密字符串
     * @return true-校验通过 false-不通过
     */
    public static boolean verifyPassword(String password, String md5) {
        char[] cs1 = new char[32];
        char[] cs2 = new char[16];
        for (int i = 0; i < 48; i += 3) {
            cs1[i / 3 * 2] = md5.charAt(i);
            cs1[i / 3 * 2 + 1] = md5.charAt(i + 2);
            cs2[i / 3] = md5.charAt(i + 1);
        }
        String salt = new String(cs2);
        return md5Hex(password + salt).equals(new String(cs1));
    }

    /**
     * 根据salt 生成16位随机盐
     *
     * @param salt salt
     * @return 16位随机盐
     */
    public static String getSalt(String salt) {
        String randomSalt = getRandomSalt();
        if (salt == null || salt.length() == 0) {
            return randomSalt;
        }
        if (salt.length() <= 16) {
            return getStringLen8(salt) + randomSalt.substring(7, 15);
        } else {
            return salt.substring(4, 12) + randomSalt.substring(2, 10);
        }
    }

    /**
     * 获取8位字符串
     *
     * @param salt salt
     * @return 8位字符串
     */
    public static String getStringLen8(String salt) {
        if (salt.length() == 8) {
            return salt;
        }
        if (salt.length() > 8) {
            return salt.substring(1, 9);
        } else {
            return getStringLen8(salt + salt);
        }
    }

    /**
     * 获取16位随机盐
     *
     * @return 16位随机字符串
     */
    public static String getRandomSalt() {
        int i1 = new Random().nextInt(99999999);
        int i2 = new Random().nextInt(99999999);
        StringBuilder salt = new StringBuilder(i1 + "" + i2);
        if (salt.length() < 16) {
            for (int i = 0; i < 16 - salt.length(); i++) {
                salt.append("0");
            }
        }
        return salt.toString();
    }
}
