package cn.ziyicloud.framework.boot.util.httpclient.config;

import cn.ziyicloud.framework.boot.enums.ErrorCodeEnum;
import cn.ziyicloud.framework.boot.exception.ZiyiException;
import cn.ziyicloud.framework.boot.util.httpclient.model.SSLProtocolVersion;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContexts;

import javax.net.ssl.*;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

/**
 * 设置ssl
 *
 * @author Li Ruitong
 */
public class SSLConfig {
    private static final SSLHandler simpleVerifier = new SSLHandler();
    private static SSLSocketFactory sslFactory;
    private static SSLConnectionSocketFactory sslConnFactory;
    private static SSLIOSessionStrategy sslIOSessionStrategy;
    private SSLContext sc;
    private static SSLConfig sslConfig = new SSLConfig();

    public static SSLConfig getInstance() {
        return sslConfig;
    }

    public static SSLConfig custom() {
        return new SSLConfig();
    }

    // 重写X509TrustManager类的三个方法,信任服务器证书
    private static class SSLHandler implements X509TrustManager, HostnameVerifier {

        @Override
        public java.security.cert.X509Certificate[] getAcceptedIssuers() {
            return new java.security.cert.X509Certificate[]{};
        }

        @Override
        public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public boolean verify(String paramString, SSLSession paramSSLSession) {
            return true;
        }
    }

    // 信任主机
    public static HostnameVerifier getVerifier() {
        return simpleVerifier;
    }

    public synchronized SSLSocketFactory getSSLSF(SSLProtocolVersion sslpv) throws ZiyiException {
        if (sslFactory != null) {
            return sslFactory;
        }
        try {
            SSLContext sc = getSSLContext(sslpv);
            sc.init(null, new TrustManager[]{simpleVerifier}, null);
            sslFactory = sc.getSocketFactory();
        } catch (KeyManagementException e) {
            throw new ZiyiException(ErrorCodeEnum.HTTP_ERROR, e);
        }
        return sslFactory;
    }

    public synchronized SSLConnectionSocketFactory getSSLCONNSF(SSLProtocolVersion sslpv) throws ZiyiException {
        if (sslConnFactory != null) {
            return sslConnFactory;
        }
        try {
            SSLContext sc = getSSLContext(sslpv);
            sc.init(null, new TrustManager[]{simpleVerifier}, new java.security.SecureRandom());
            sslConnFactory = new SSLConnectionSocketFactory(sc, simpleVerifier);
        } catch (KeyManagementException e) {
            throw new ZiyiException(ErrorCodeEnum.HTTP_ERROR, e);
        }
        return sslConnFactory;
    }

    public synchronized SSLIOSessionStrategy getSSLIOSS(SSLProtocolVersion sslpv) throws ZiyiException {
        if (sslIOSessionStrategy != null) {
            return sslIOSessionStrategy;
        }
        try {
            SSLContext sc = getSSLContext(sslpv);
            sc.init(null, new TrustManager[]{simpleVerifier}, new java.security.SecureRandom());
            sslIOSessionStrategy = new SSLIOSessionStrategy(sc, simpleVerifier);
        } catch (KeyManagementException e) {
            throw new ZiyiException(ErrorCodeEnum.HTTP_ERROR, e);
        }
        return sslIOSessionStrategy;
    }

    public SSLConfig customSSL(String keyStorePath, String keyStorepass) throws ZiyiException {
        try (FileInputStream ins = new FileInputStream(new File(keyStorePath))) {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(ins, keyStorepass.toCharArray());
            // 相信自己的CA和所有自签名的证书
            sc = SSLContexts.custom().loadTrustMaterial(trustStore, new TrustSelfSignedStrategy()).build();
        } catch (Exception e) {
            throw new ZiyiException(ErrorCodeEnum.HTTP_ERROR, e);
        }
        return this;
    }

    public SSLContext getSSLContext(SSLProtocolVersion sslpv) throws ZiyiException {
        try {
            if (sc == null) {
                sc = SSLContext.getInstance(sslpv.getName());
            }
            return sc;
        } catch (NoSuchAlgorithmException e) {
            throw new ZiyiException(ErrorCodeEnum.HTTP_ERROR, e);
        }
    }

}
