package cn.ziyicloud.framework.boot.util.io;

import java.io.Closeable;
import java.io.IOException;

/**
 * Closeable 工具类
 *
 * @author Li Ruitong
 * @date 2020/5/14
 */
public class CloseableUtils {
    private CloseableUtils() {
    }


    /**
     * 关闭资源流
     *
     * @param closeable 实现closeable接口的IO类
     */
    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            } catch (IOException ex) {
                // ignore
            }
        }
    }
}
