package cn.ziyicloud.framework.boot.util.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 构建树工具方法
 *
 * @author Li Ruitong
 * @version 1.0
 * @date 2020/3/6
 */
public class TreeUtils {

    /**
     * 双层循环构建树
     *
     * @param treeNodes 节点列表
     * @param <T>       泛型节点的实体类
     * @return 树
     */
    public static <T extends TreeNode<T>> List<T> build(List<T> treeNodes) {
        List<T> trees = new ArrayList<>();
        List<Long> ids = treeNodes.stream().map(TreeNode::getId).collect(Collectors.toList());

        for (T treeNode : treeNodes) {

            if (!ids.contains(treeNode.getPid())) {
                trees.add(treeNode);
            }

            for (T it : treeNodes) {
                if (it.getPid().equals(treeNode.getId())) {
                    if (treeNode.getChildren() == null) {
                        treeNode.setChildren(new ArrayList<>());
                    }
                    treeNode.getChildren().add(it);
                }
            }
        }
        return trees;
    }

    /**
     * 使用递归方法建树
     *
     * @param treeNodes 节点列表
     * @param <T>       泛型节点的实体类
     * @return 树
     */
    public static <T extends TreeNode<T>> List<T> buildByRecursive(List<T> treeNodes) {
        List<T> trees = new ArrayList<>();
        List<Long> ids = treeNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
        for (T treeNode : treeNodes) {
            if (!ids.contains(treeNode.getPid())) {
                trees.add(findChildren(treeNode, treeNodes));
            }
        }
        return trees;
    }

    /**
     * 递归查找子节点
     *
     * @param treeNodes 节点列表
     * @param <T>       泛型节点的实体类
     * @return 子节点
     */
    private static <T extends TreeNode<T>> T findChildren(T treeNode, List<T> treeNodes) {
        for (T it : treeNodes) {
            if (treeNode.getId().equals(it.getPid())) {
                if (treeNode.getChildren() == null) {
                    treeNode.setChildren(new ArrayList<>());
                }
                treeNode.getChildren().add(findChildren(it, treeNodes));
            }
        }
        return treeNode;
    }
}
