/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.conlection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionUtils {
    private static final Logger log = LoggerFactory.getLogger(CollectionUtils.class);

    public static <T> List<List<T>> splitListByItemNum(List<T> srcList, int itemNum) {
        ArrayList<List<T>> results = new ArrayList<List<T>>();
        if (srcList == null) {
            log.info("\u6309\u6bcf\u4e2a\u96c6\u5408\u4e2d\u5143\u7d20\u4e2a\u6570\u62c6\u5206list\uff1asrcList \u4e0d\u80fd\u4e3anull");
            return results;
        }
        if (itemNum < 1) {
            log.info("\u6309\u6bcf\u4e2a\u96c6\u5408\u4e2d\u5143\u7d20\u4e2a\u6570\u62c6\u5206list\uff1aitemNum \u4e0d\u80fd\u5c0f\u4e8e1");
            return results;
        }
        int size = srcList.size();
        int count = (int)Math.ceil((double)size * 1.0 / (double)itemNum);
        for (int i = 0; i < count; ++i) {
            int fromIndex = itemNum * i;
            int toIndex = Math.min(itemNum * (i + 1), size);
            results.add(srcList.subList(fromIndex, toIndex));
        }
        return results;
    }

    public static <T> List<List<T>> splitList(List<T> srcList, int listNum) {
        ArrayList<List<T>> results = new ArrayList<List<T>>();
        if (srcList == null) {
            log.info("\u6309\u4e2a\u6570\u62c6\u5206list\uff1asrcList \u4e0d\u80fd\u4e3anull");
            return results;
        }
        if (listNum < 1) {
            log.info("\u6309\u4e2a\u6570\u62c6\u5206list\uff1aitemNum \u4e0d\u80fd\u5c0f\u4e8e1");
            return results;
        }
        int size = srcList.size();
        if (size <= listNum) {
            return CollectionUtils.splitListByItemNum(srcList, 1);
        }
        int itemNum = size / listNum;
        for (int i = 0; i < listNum; ++i) {
            int fromIndex = itemNum * i;
            int toIndex = itemNum * (i + 1);
            if (i == listNum - 1) {
                toIndex = srcList.size() - 1;
            }
            results.add(srcList.subList(fromIndex, toIndex));
        }
        return results;
    }

    public static <T> List<T> toPage(List<T> srcList, int page, int pageSize) {
        if (srcList == null) {
            log.info("\u96c6\u5408\u5206\u9875\uff1asrcList \u4e0d\u80fd\u4e3anull");
            return new ArrayList(0);
        }
        if (page < 0 || pageSize < 1) {
            log.info("\u96c6\u5408\u5206\u9875\uff1apage\u4e0d\u80fd\u5c0f\u4e8e0\u4e14pageSize\u4e0d\u80fd\u5c0f\u4e8e1");
            return new ArrayList(0);
        }
        int fromIndex = pageSize * page;
        int toIndex = pageSize * (page + 1);
        int size = srcList.size();
        if (fromIndex > size) {
            return new ArrayList(0);
        }
        if (toIndex >= size) {
            return srcList.subList(fromIndex, size);
        }
        return srcList.subList(fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> deepCopyList(List<T> srcList) throws ClassNotFoundException {
        List resultList = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream os = null;
        ByteArrayInputStream bis = null;
        ObjectInputStream is = null;
        try {
            bos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(bos);
            os.writeObject(srcList);
            bis = new ByteArrayInputStream(bos.toByteArray());
            is = new ObjectInputStream(bis);
            resultList = (List)is.readObject();
        }
        catch (IOException e) {
            try {
                log.info("\u6df1\u5ea6\u590d\u5236list\u96c6\u5408\u51fa\u9519", (Throwable)e);
            }
            catch (Throwable throwable) {
                CollectionUtils.close(is);
                CollectionUtils.close(bis);
                CollectionUtils.close(os);
                CollectionUtils.close(bos);
                throw throwable;
            }
            CollectionUtils.close(is);
            CollectionUtils.close(bis);
            CollectionUtils.close(os);
            CollectionUtils.close(bos);
        }
        CollectionUtils.close(is);
        CollectionUtils.close(bis);
        CollectionUtils.close(os);
        CollectionUtils.close(bos);
        return resultList;
    }

    public static <T> List<T> retainElementList(List<List<T>> elementLists) {
        Optional<List> result = elementLists.parallelStream().filter(elementList -> elementList != null && elementList.size() != 0).reduce((a, b) -> {
            a.retainAll((Collection<?>)b);
            return a;
        });
        return result.orElse(new ArrayList());
    }

    public static <T> List<T> subtractions(Collection<T> colA, Collection<T> colB) {
        return colA.stream().filter(s -> !colB.contains(s)).collect(Collectors.toList());
    }

    public static <T> List<T> intersections(Collection<T> colA, Collection<T> colB) {
        return colA.stream().filter(colB::contains).collect(Collectors.toList());
    }

    public static <T> List<T> unions(Collection<T> colA, Collection<T> colB) {
        colA.addAll(colB);
        return colA.stream().distinct().collect(Collectors.toList());
    }

    public static <T> Set<T> listToSet(List<T> list) {
        return new HashSet<T>(list);
    }

    public static <T> List<T> setToList(Set<T> set) {
        return new ArrayList<T>(set);
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

