/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.json;

import cn.ziyicloud.framework.boot.enums.ErrorCodeEnum;
import cn.ziyicloud.framework.boot.exception.ZiyiException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();

    private JsonUtils() {
    }

    public static ObjectMapper getInstance() {
        return JSON_OBJECT_MAPPER;
    }

    public static String toJson(Object value) {
        return JsonUtils.toJson(value, JSON_OBJECT_MAPPER);
    }

    public static String toJsonIgnoreNull(Object value) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return JsonUtils.toJson(value, mapper);
    }

    public static String toJson(Object value, ObjectMapper mapper) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new ZiyiException(ErrorCodeEnum.UTIL_ERROR, (Throwable)e);
        }
    }

    public static <T> T parse(String content, Class<T> valueType) {
        return JsonUtils.parse(content, valueType, null, JSON_OBJECT_MAPPER);
    }

    public static <T> T parse(String content, Class<T> valueType, ObjectMapper mapper) {
        return JsonUtils.parse(content, valueType, null, mapper);
    }

    public static <T> List<T> parseArray(String content, Class<T> valueType) {
        return (List)JsonUtils.parse(content, null, new TypeReference<List<T>>(){}, JSON_OBJECT_MAPPER);
    }

    public static <T> List<T> parseArray(String content, Class<T> valueType, ObjectMapper mapper) {
        return (List)JsonUtils.parse(content, null, new TypeReference<List<T>>(){}, mapper);
    }

    public static <T> T parse(String content, TypeReference<T> valueTypeRef) {
        return JsonUtils.parse(content, null, valueTypeRef, JSON_OBJECT_MAPPER);
    }

    public static <T> T parse(String content, TypeReference<T> valueTypeRef, ObjectMapper mapper) {
        return JsonUtils.parse(content, null, valueTypeRef, mapper);
    }

    public static <T> T parse(String content, Class<T> valueType, TypeReference<T> valueTypeRef, ObjectMapper mapper) {
        Object obj = null;
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            try {
                obj = valueType != null ? mapper.readValue(content, valueType) : mapper.readValue(content, valueTypeRef);
            }
            catch (JsonProcessingException e) {
                throw new ZiyiException(ErrorCodeEnum.UTIL_ERROR, (Throwable)e);
            }
        }
        return (T)obj;
    }

    static {
        JSON_OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        JSON_OBJECT_MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        JSON_OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        JSON_OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JSON_OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        JSON_OBJECT_MAPPER.configure(SerializationFeature.INDENT_OUTPUT, true);
    }
}

