/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.tree;

import cn.ziyicloud.framework.boot.util.tree.TreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TreeUtils {
    public static <T extends TreeNode<T>> List<T> build(List<T> treeNodes) {
        ArrayList<TreeNode> trees = new ArrayList<TreeNode>();
        List ids = treeNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
        for (TreeNode treeNode : treeNodes) {
            if (!ids.contains(treeNode.getPid())) {
                trees.add(treeNode);
            }
            for (TreeNode it : treeNodes) {
                if (!it.getPid().equals(treeNode.getId())) continue;
                if (treeNode.getChildren() == null) {
                    treeNode.setChildren(new ArrayList());
                }
                treeNode.getChildren().add(it);
            }
        }
        return trees;
    }

    public static <T extends TreeNode<T>> List<T> buildByRecursive(List<T> treeNodes) {
        ArrayList<TreeNode> trees = new ArrayList<TreeNode>();
        List ids = treeNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
        for (TreeNode treeNode : treeNodes) {
            if (ids.contains(treeNode.getPid())) continue;
            trees.add(TreeUtils.findChildren(treeNode, treeNodes));
        }
        return trees;
    }

    private static <T extends TreeNode<T>> T findChildren(T treeNode, List<T> treeNodes) {
        for (TreeNode it : treeNodes) {
            if (!treeNode.getId().equals(it.getPid())) continue;
            if (treeNode.getChildren() == null) {
                treeNode.setChildren(new ArrayList());
            }
            treeNode.getChildren().add(TreeUtils.findChildren(it, treeNodes));
        }
        return (T)treeNode;
    }
}

