package cn.ziyicloud.framework.boot.model;

import cn.ziyicloud.framework.boot.enums.ErrorCodeEnum;
import cn.ziyicloud.framework.boot.exception.ZiyiException;
import lombok.Getter;
import lombok.Setter;

/**
 * 统一返回前端数据的超类
 *
 * @author Li Ruitong
 * @date 2020/5/15
 */
@Getter
@Setter
public class ZiyiResponse {
    /**
     * 错误代码
     */
    private Integer rtn;
    /**
     * 错误信息
     */
    private String message;

    public ZiyiResponse() {
        this.rtn = ErrorCodeEnum.SUCCESS.getRtn();
        this.message = ErrorCodeEnum.SUCCESS.getMessage();
    }

    public ZiyiResponse(Integer rtn, String message) {
        this.rtn = rtn;
        this.message = message;
    }

    public ZiyiResponse(ErrorCodeEnum errorCode) {
        this.rtn = errorCode.getRtn();
        this.message = errorCode.getMessage();
    }

    public ZiyiResponse(ErrorCodeEnum errorCode, String message) {
        this.rtn = errorCode.getRtn();
        this.message = message;
    }

    public ZiyiResponse(ZiyiException e) {
        this.rtn = e.getRtn();
        this.message = e.getMessage();
    }

    public ZiyiResponse(ZiyiException e, String message) {
        this.rtn = e.getRtn();
        this.message = message;
    }

    /**
     * 请求是否通过
     */
    public boolean valid() {
        return (0 == this.rtn);
    }
}
