/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util;

import cn.hutool.http.useragent.Browser;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.lionsoul.ip2region.DataBlock;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.DbSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);
    private static final String X_FORWARDED_FOR = "x-forwarded-for";
    private static final String X_REAL_IP = "x-real-ip";
    private static final String REMOTE_ADDR = "remote_addr";
    private static final String UNKNOWN = "unknown";
    private static final String REGION = "\u5185\u7f51IP|\u5185\u7f51IP";

    private IpUtils() {
    }

    public static String getIp(HttpServletRequest request) {
        String ip = request.getHeader(X_REAL_IP);
        if (!StringUtils.isBlank((CharSequence)ip) && !UNKNOWN.equalsIgnoreCase(ip)) {
            return ip;
        }
        ip = request.getHeader(X_FORWARDED_FOR);
        if (!StringUtils.isBlank((CharSequence)ip) && !UNKNOWN.equalsIgnoreCase(ip)) {
            int index = ip.indexOf(44);
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static String getBrowser(HttpServletRequest request) {
        UserAgent userAgent = UserAgentParser.parse((String)request.getHeader("User-Agent"));
        Browser browser = userAgent.getBrowser();
        return browser.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCityInfo(String ip) {
        String dbPath = IpUtils.class.getResource("/ip2region/ip2region.db").getPath();
        File file = new File(dbPath);
        if (!file.exists()) {
            log.info("\u5730\u5740\u5e93\u6587\u4ef6\u4e0d\u5b58\u5728,\u8fdb\u884c\u5176\u4ed6\u5904\u7406");
            String tmpDir = System.getProperties().getProperty("java.io.tmpdir");
            dbPath = tmpDir + File.separator + "ip2region.db";
            log.info("\u4e34\u65f6\u6587\u4ef6\u8def\u5f84:{}", (Object)dbPath);
            file = new File(dbPath);
            if (!file.exists() || System.currentTimeMillis() - file.lastModified() > 86400000L) {
                log.info("\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u8005\u6587\u4ef6\u5b58\u5728\u65f6\u95f4\u8d85\u8fc71\u5929\u8fdb\u5165...");
                try {
                    InputStream inputStream = new ClassPathResource("ip2region/ip2region.db").getInputStream();
                    IOUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(file));
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        DbSearcher searcher = null;
        try {
            DbConfig config = new DbConfig();
            searcher = new DbSearcher(config, file.getPath());
            Method method = searcher.getClass().getMethod("btreeSearch", String.class);
            DataBlock dataBlock = (DataBlock)method.invoke((Object)searcher, ip);
            String address = dataBlock.getRegion().replace("0|", "");
            char symbol = '|';
            if (address.charAt(address.length() - 1) == symbol) {
                address = address.substring(0, address.length() - 1);
            }
            String string = address.equals(REGION) ? "\u5185\u7f51IP" : address;
            return string;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (IOException iOException) {}
            }
        }
        return "";
    }
}

