/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.crypto;

import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;

public class Md5Utils {
    public static String md5Hex(String source) {
        return DigestUtils.md5Hex((String)source);
    }

    public static String generatePassword(String password, String userName) {
        String salt = Md5Utils.getSalt(userName);
        password = Md5Utils.md5Hex(password + salt);
        char[] cs = new char[48];
        for (int i = 0; i < 48; i += 3) {
            char c;
            cs[i] = password.charAt(i / 3 * 2);
            cs[i + 1] = c = salt.charAt(i / 3);
            cs[i + 2] = password.charAt(i / 3 * 2 + 1);
        }
        return new String(cs);
    }

    public static boolean verifyPassword(String password, String md5) {
        char[] cs1 = new char[32];
        char[] cs2 = new char[16];
        for (int i = 0; i < 48; i += 3) {
            cs1[i / 3 * 2] = md5.charAt(i);
            cs1[i / 3 * 2 + 1] = md5.charAt(i + 2);
            cs2[i / 3] = md5.charAt(i + 1);
        }
        String salt = new String(cs2);
        return Md5Utils.md5Hex(password + salt).equals(new String(cs1));
    }

    public static String getSalt(String salt) {
        String randomSalt = Md5Utils.getRandomSalt();
        if (salt == null || salt.length() == 0) {
            return randomSalt;
        }
        if (salt.length() <= 16) {
            return Md5Utils.getStringLen8(salt) + randomSalt.substring(7, 15);
        }
        return salt.substring(4, 12) + randomSalt.substring(2, 10);
    }

    public static String getStringLen8(String salt) {
        if (salt.length() == 8) {
            return salt;
        }
        if (salt.length() > 8) {
            return salt.substring(1, 9);
        }
        return Md5Utils.getStringLen8(salt + salt);
    }

    public static String getRandomSalt() {
        int i1 = new Random().nextInt(99999999);
        int i2 = new Random().nextInt(99999999);
        StringBuilder salt = new StringBuilder(i1 + "" + i2);
        if (salt.length() < 16) {
            for (int i = 0; i < 16 - salt.length(); ++i) {
                salt.append("0");
            }
        }
        return salt.toString();
    }
}

