/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.httpclient.builder;

import cn.ziyicloud.framework.boot.util.httpclient.config.SSLConfig;
import cn.ziyicloud.framework.boot.util.httpclient.model.SSLProtocolVersion;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class HttpClientBuilderUtil
extends HttpClientBuilder {
    public boolean isSetPool = false;
    private SSLProtocolVersion sslpv = SSLProtocolVersion.TLSv1_2;
    private SSLConfig ssls = SSLConfig.getInstance();

    private HttpClientBuilderUtil() {
    }

    public static HttpClientBuilderUtil custom() {
        return new HttpClientBuilderUtil();
    }

    public HttpClientBuilderUtil timeout(int timeout) {
        return this.timeout(timeout, true);
    }

    public HttpClientBuilderUtil timeout(int timeout, boolean redirectEnable) {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout).setRedirectsEnabled(redirectEnable).build();
        return (HttpClientBuilderUtil)this.setDefaultRequestConfig(config);
    }

    public HttpClientBuilderUtil ssl() {
        return (HttpClientBuilderUtil)this.setSSLSocketFactory((LayeredConnectionSocketFactory)this.ssls.getSSLCONNSF(this.sslpv));
    }

    public HttpClientBuilderUtil ssl(String keyStorePath) {
        return this.ssl(keyStorePath, "nopassword");
    }

    public HttpClientBuilderUtil ssl(String keyStorePath, String keyStorepass) {
        this.ssls = SSLConfig.custom().customSSL(keyStorePath, keyStorepass);
        return this.ssl();
    }

    public HttpClientBuilderUtil pool(int maxTotal, int defaultMaxPerRoute) {
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)this.ssls.getSSLCONNSF(this.sslpv)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setMaxTotal(maxTotal);
        connManager.setDefaultMaxPerRoute(defaultMaxPerRoute);
        this.isSetPool = true;
        return (HttpClientBuilderUtil)this.setConnectionManager((HttpClientConnectionManager)connManager);
    }

    public HttpClientBuilderUtil digest(String username, String password) {
        return this.digest(username, password, null, null);
    }

    public HttpClientBuilderUtil digest(String username, String password, String host, Integer port) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(StringUtils.isBlank((CharSequence)host) ? AuthScope.ANY_HOST : host, port == null ? -1 : port), (Credentials)new UsernamePasswordCredentials(username, password));
        return (HttpClientBuilderUtil)this.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    public HttpClientBuilderUtil proxy(String hostOrIP, int port) {
        HttpHost proxy = new HttpHost(hostOrIP, port, "http");
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
        return (HttpClientBuilderUtil)this.setRoutePlanner((HttpRoutePlanner)routePlanner);
    }

    public HttpClientBuilderUtil retry(int tryTimes) {
        return this.retry(tryTimes, false);
    }

    public HttpClientBuilderUtil retry(int tryTimes, boolean retryWhenInterruptedIo) {
        HttpRequestRetryHandler httpRequestRetryHandler = (exception, executionCount, context) -> {
            if (executionCount >= tryTimes) {
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                return true;
            }
            if (exception instanceof ConnectTimeoutException) {
                return true;
            }
            if (exception instanceof UnknownHostException) {
                return true;
            }
            if (exception instanceof SSLHandshakeException) {
                return false;
            }
            if (exception instanceof SSLException) {
                return false;
            }
            if (exception instanceof InterruptedIOException) {
                return retryWhenInterruptedIo;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            HttpRequest request = clientContext.getRequest();
            return !(request instanceof HttpEntityEnclosingRequest);
        };
        this.setRetryHandler(httpRequestRetryHandler);
        return this;
    }

    public HttpClientBuilderUtil sslpv(String sslpv) {
        return this.sslpv(SSLProtocolVersion.find(sslpv));
    }

    public HttpClientBuilderUtil sslpv(SSLProtocolVersion sslpv) {
        this.sslpv = sslpv;
        return this;
    }
}

