/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.httpclient.config;

import cn.ziyicloud.framework.boot.enums.ErrorCodeEnum;
import cn.ziyicloud.framework.boot.exception.ZiyiException;
import cn.ziyicloud.framework.boot.util.httpclient.model.SSLProtocolVersion;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class SSLConfig {
    private static final SSLHandler simpleVerifier = new SSLHandler();
    private static SSLSocketFactory sslFactory;
    private static SSLConnectionSocketFactory sslConnFactory;
    private static SSLIOSessionStrategy sslIOSessionStrategy;
    private SSLContext sc;
    private static SSLConfig sslConfig;

    public static SSLConfig getInstance() {
        return sslConfig;
    }

    public static SSLConfig custom() {
        return new SSLConfig();
    }

    public static HostnameVerifier getVerifier() {
        return simpleVerifier;
    }

    public synchronized SSLSocketFactory getSSLSF(SSLProtocolVersion sslpv) throws ZiyiException {
        if (sslFactory != null) {
            return sslFactory;
        }
        try {
            SSLContext sc = this.getSSLContext(sslpv);
            sc.init(null, new TrustManager[]{simpleVerifier}, null);
            sslFactory = sc.getSocketFactory();
        }
        catch (KeyManagementException e) {
            throw new ZiyiException(ErrorCodeEnum.HTTP_ERROR, (Throwable)e);
        }
        return sslFactory;
    }

    public synchronized SSLConnectionSocketFactory getSSLCONNSF(SSLProtocolVersion sslpv) throws ZiyiException {
        if (sslConnFactory != null) {
            return sslConnFactory;
        }
        try {
            SSLContext sc = this.getSSLContext(sslpv);
            sc.init(null, new TrustManager[]{simpleVerifier}, new SecureRandom());
            sslConnFactory = new SSLConnectionSocketFactory(sc, (HostnameVerifier)simpleVerifier);
        }
        catch (KeyManagementException e) {
            throw new ZiyiException(ErrorCodeEnum.HTTP_ERROR, (Throwable)e);
        }
        return sslConnFactory;
    }

    public synchronized SSLIOSessionStrategy getSSLIOSS(SSLProtocolVersion sslpv) throws ZiyiException {
        if (sslIOSessionStrategy != null) {
            return sslIOSessionStrategy;
        }
        try {
            SSLContext sc = this.getSSLContext(sslpv);
            sc.init(null, new TrustManager[]{simpleVerifier}, new SecureRandom());
            sslIOSessionStrategy = new SSLIOSessionStrategy(sc, (HostnameVerifier)simpleVerifier);
        }
        catch (KeyManagementException e) {
            throw new ZiyiException(ErrorCodeEnum.HTTP_ERROR, (Throwable)e);
        }
        return sslIOSessionStrategy;
    }

    public SSLConfig customSSL(String keyStorePath, String keyStorepass) throws ZiyiException {
        try (FileInputStream ins = new FileInputStream(new File(keyStorePath));){
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(ins, keyStorepass.toCharArray());
            this.sc = SSLContexts.custom().loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        }
        catch (Exception e) {
            throw new ZiyiException(ErrorCodeEnum.HTTP_ERROR, (Throwable)e);
        }
        return this;
    }

    public SSLContext getSSLContext(SSLProtocolVersion sslpv) throws ZiyiException {
        try {
            if (this.sc == null) {
                this.sc = SSLContext.getInstance(sslpv.getName());
            }
            return this.sc;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ZiyiException(ErrorCodeEnum.HTTP_ERROR, (Throwable)e);
        }
    }

    static {
        sslConfig = new SSLConfig();
    }

    private static class SSLHandler
    implements X509TrustManager,
    HostnameVerifier {
        private SSLHandler() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public boolean verify(String paramString, SSLSession paramSSLSession) {
            return true;
        }
    }
}

