/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.httpclient.util;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUrlUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUrlUtils.class);

    public static String buildHttps(String hostname, String port, String path) {
        return HttpUrlUtils.build(Protocol.HTTPS, hostname, port, path, null);
    }

    public static String buildHttps(String hostname, String port, String path, Map<String, String> parameters) {
        return HttpUrlUtils.build(Protocol.HTTPS, hostname, port, path, parameters);
    }

    public static String buildHttp(String hostname, String port, String path) {
        return HttpUrlUtils.build(Protocol.HTTP, hostname, port, path, null);
    }

    public static String buildHttp(String hostname, String port, String path, Map<String, String> parameters) {
        return HttpUrlUtils.build(Protocol.HTTP, hostname, port, path, parameters);
    }

    public static String build(Protocol protocol, String hostname, String port, String path, Map<String, String> parameters) {
        String urlParam;
        if (log.isDebugEnabled()) {
            log.debug("\u5f00\u59cb\u6784\u5efa\u53c2\u6570\u3002protocol={};hostname={};port={},path={},parameters={}", new Object[]{protocol.prefix, hostname, port, path, port});
        }
        StringBuilder url = new StringBuilder();
        url.append(protocol.getPrefix()).append(hostname);
        if (StringUtils.isNotEmpty((CharSequence)port)) {
            url.append(":").append(port);
        }
        String separate = "/";
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            if (!path.startsWith(separate)) {
                url.append(separate);
            }
            url.append(path);
            if (path.endsWith(separate)) {
                url.deleteCharAt(url.length() - 1);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(urlParam = HttpUrlUtils.buildParameters(parameters)))) {
            if (HttpUrlUtils.checkHasParamters(path)) {
                url.append("&");
            } else {
                url.append("?");
            }
            url.append(urlParam);
        }
        return url.toString();
    }

    public static boolean checkHasParamters(String url) {
        return url.contains("?") && url.indexOf("?") < url.indexOf("=");
    }

    public static String buildParameters(Map<String, String> parameters) {
        if (parameters == null) {
            return "";
        }
        StringBuilder paramStr = new StringBuilder();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            paramStr.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (paramStr.length() == 0) {
            return "";
        }
        return paramStr.substring(1);
    }

    private static enum Protocol {
        HTTP("http://"),
        HTTPS("https://");

        private String prefix;

        private Protocol(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

