package cn.ziyicloud.framework.boot.util;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * id工具类
 *
 * @author Li Ruitong
 * @version 1.0
 * @date 2020/3/11
 */
public class IdUtils {
    /**
     * 从对象集合中获取对象的id列表
     *
     * @param col  要获取id列表的对象集合
     * @param <T>  对象类型
     * @param <ID> id类型
     * @return id列表
     */
    public static <T extends HasId<ID>, ID extends Serializable> List<ID> getIds(Collection<T> col) {
        if (null == col) {
            return null;
        }
        return col.stream().filter(Objects::nonNull).map(T::getId).filter(Objects::nonNull).collect(Collectors.toList());
    }

    /**
     * 对象集合转map
     *
     * @param col  要获取id列表的对象集合
     * @param <T>  对象类型
     * @param <ID> id类型
     * @return idMap
     */
    public static <T extends HasId<ID>, ID extends Serializable> Map<ID, T> getIdMap(Collection<T> col) {
        if (null == col) {
            return null;
        }
        Map<ID, T> idMap = new HashMap<>();
        for (T t : col) {
            idMap.put(t.getId(), t);
        }
        return idMap;
    }

    /**
     * 想要用IdUtils工具简化获取id代码就要实现该接口
     *
     * @author Li Ruitong
     * @version 1.0
     * @date 2020/3/11
     */
    public interface HasId<ID extends Serializable> {
        /**
         * 获取id
         *
         * @return ID
         */
        ID getId();
    }
}
