package cn.ziyicloud.framework.boot.util.httpclient.config;

import org.apache.http.client.CookieStore;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCookieStore;

/**
 * 封装Cookie
 *
 * @author Li Ruitong
 */
public class HttpCookies {
    /**
     * 使用httpcontext，用于设置和携带Cookie
     */
    private HttpClientContext context;

    /**
     * 储存Cookie
     */
    private CookieStore cookieStore;

    /**
     * 私有构造方法
     */
    private HttpCookies() {
        this.context = new HttpClientContext();
        this.cookieStore = new BasicCookieStore();
        this.context.setCookieStore(cookieStore);
    }

    /**
     * 获取实例
     *
     * @return 返回当前对象
     */
    public static HttpCookies custom() {
        return new HttpCookies();
    }

    /**
     * 设置httpcontext
     *
     * @param context context
     * @return 返回当前对象
     */
    public HttpCookies setContext(HttpClientContext context) {
        this.context = context;
        return this;
    }

    /**
     * 设置 cookieStore
     *
     * @param cookieStore cookieStore
     * @return 返回当前对象
     */
    public HttpCookies setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    /**
     * 获取httpcontext
     *
     * @return 返回httpcontext对象
     */
    public HttpClientContext getContext() {
        return context;
    }

    /**
     * 获取CookieStore
     *
     * @return CookieStore对象
     */
    public CookieStore getCookieStore() {
        return cookieStore;
    }
}
