/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringContextHolder
implements ApplicationContextAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(SpringContextHolder.class);
    private static ApplicationContext applicationContext = null;

    public static <T> T getBean(String name) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> requiredType) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(requiredType);
    }

    private static void assertContextInjected() {
        if (applicationContext == null) {
            throw new IllegalStateException("applicaitonContext\u5c5e\u6027\u672a\u6ce8\u5165, \u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder\u6216\u5728SpringBoot\u542f\u52a8\u7c7b\u4e2d\u6ce8\u518cSpringContextHolder.");
        }
    }

    private static void clearHolder() {
        log.debug("\u6e05\u9664SpringContextHolder\u4e2d\u7684ApplicationContext:" + applicationContext);
        applicationContext = null;
    }

    public void destroy() {
        SpringContextHolder.clearHolder();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (SpringContextHolder.applicationContext != null) {
            log.warn("SpringContextHolder\u4e2d\u7684ApplicationContext\u88ab\u8986\u76d6, \u539f\u6709ApplicationContext\u4e3a:" + SpringContextHolder.applicationContext);
        }
        SpringContextHolder.applicationContext = applicationContext;
    }
}

