/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static byte[] fileToBinArray(File file) {
        byte[] bytes = null;
        try (FileInputStream fis = new FileInputStream(file);){
            bytes = IOUtils.toByteArray((InputStream)fis);
        }
        catch (IOException e) {
            log.info("\u6587\u4ef6\u8f6c\u4e8c\u8fdb\u5236\u6570\u7ec4\u51fa\u9519", (Throwable)e);
        }
        return bytes;
    }

    public static byte[] urlFileToBinArray(String fileUrlPath) {
        byte[] bytes = null;
        try {
            URL url = new URL(fileUrlPath);
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.connect();
            InputStream is = httpConn.getInputStream();
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            log.info("\u7f51\u7edc\u6587\u4ef6\u8f6c\u4e8c\u8fdb\u5236\u6570\u7ec4\u51fa\u9519", (Throwable)e);
        }
        return bytes;
    }

    public static File inputStreamToFile(InputStream inputStream, String filename) throws IOException {
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + filename);
        if (file.exists()) {
            return file;
        }
        FileOutputStream os = new FileOutputStream(file);
        IOUtils.copy((InputStream)inputStream, (OutputStream)os);
        return file;
    }
}

