package cn.ziyicloud.framework.boot.util.crypto;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

/**
 * base64工具类
 *
 * @author Li Ruitong
 * @date 2020/5/13
 */
public class Base64Utils {
    private Base64Utils() {
    }

    /**
     * base64加密
     */
    public static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    /**
     * base64解密
     */
    public static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();

    /**
     * 将byte array构建成字符串
     *
     * @param src the byte array to decode
     * @return 由byte array 构建的字符串
     */
    public static String buildStr(byte[] src) {
        if (src == null) {
            return null;
        }
        return new String(src, 0, src.length, StandardCharsets.UTF_8);
    }

    /**
     * 将byte array进行base64加密形成新的byte array
     *
     * @param src the byte array to encode
     * @return base64加密形成新的byte array
     */
    public static byte[] encode(byte[] src) {
        if (src == null) {
            return null;
        }
        return BASE64_ENCODER.encode(src);
    }

    /**
     * 将字符串进行base64加密形成新的byte array
     *
     * @param src the String to encode
     * @return base64加密形成新的byte array
     */
    public static byte[] encode(String src) {
        if (src == null) {
            return null;
        }
        return BASE64_ENCODER.encode(src.getBytes(StandardCharsets.UTF_8));
    }


    /**
     * 将byte array进行base64加密形成新的字符串
     *
     * @param src the byte array to encode
     * @return base64加密形成新的字符串
     */
    public static String encodeToString(byte[] src) {
        byte[] encoded = encode(src);
        return buildStr(encoded);
    }

    /**
     * 将byte array进行base64加密形成新的字符串
     *
     * @param src the byte array to encode
     * @return base64加密形成新的字符串
     */
    public static String encodeToString(String src) {
        byte[] encoded = encode(src);
        return buildStr(encoded);
    }

    /**
     * 将base64加密的byte array进行base64解密形成新的byte array
     *
     * @param src the byte array to decode
     * @return base64解密形成新的byte array
     */
    public static byte[] decode(byte[] src) {
        return BASE64_DECODER.decode(src);
    }

    /**
     * 将base64加密的字符串进行base64解密形成新的byte array
     *
     * @param src the byte array to decode
     * @return base64解密形成新的byte array
     */
    public static byte[] decode(String src) {
        return BASE64_DECODER.decode(src);
    }


    /**
     * 将base64加密的byte array进行base64解密形成新的字符串
     *
     * @param src the byte array to decode
     * @return base64解密形成新的byte array
     */
    public static String decodeToString(byte[] src) {
        byte[] decode = decode(src);
        return buildStr(decode);
    }


    /**
     * 将base64加密的字符串进行base64解密形成新的byte array
     *
     * @param src the byte array to decode
     * @return base64解密形成新的字符串
     */
    public static String decodeToString(String src) {
        byte[] decode = decode(src);
        return buildStr(decode);
    }
}
