package cn.ziyicloud.framework.boot.util.wx;

import cn.ziyicloud.framework.boot.exception.ZiyiException;
import cn.ziyicloud.framework.boot.util.crypto.Base64Utils;
import cn.ziyicloud.framework.boot.util.httpclient.HttpClientUtil;
import cn.ziyicloud.framework.boot.util.json.JsonUtils;
import lombok.extern.slf4j.Slf4j;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

/**
 * 微信相关工具类
 *
 * @author Li Ruitong
 * @date 2020/5/28
 */
@Slf4j
public class WechartUtils {
    private WechartUtils() {
    }

    public static final String JS_CODE_TO_SESSION = "https://api.weixin.qq.com/sns/jscode2session";
    public static final String GRANT_TYPE = "authorization_code";

    /**
     * 解密小程序加密数据
     *
     * @param sessionKey    加密key
     * @param encryptedData 加密数据
     * @param iv            偏移
     * @return 解密后的字符串
     */
    public static WechatUserInfo decrypt(String sessionKey, String encryptedData, String iv) {
        byte[] key = Base64Utils.decode(sessionKey);
        byte[] data = Base64Utils.decode(encryptedData);
        byte[] ivKey = Base64Utils.decode(iv);
        AlgorithmParameterSpec ivSpec = new IvParameterSpec(ivKey);
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            cipher.init(Cipher.DECRYPT_MODE, keySpec, ivSpec);
            return JsonUtils.parse(new String(cipher.doFinal(data), StandardCharsets.UTF_8), WechatUserInfo.class);
        } catch (NoSuchAlgorithmException | NoSuchPaddingException | InvalidKeyException | InvalidAlgorithmParameterException | BadPaddingException | IllegalBlockSizeException e) {
            if (log.isDebugEnabled()) {
                log.debug("微信小程序数据解密失败", e);
            }
        }
        return null;
    }

    public static String getWxSessionKey(String appId, String appSecret, String jsCode) {
        String result = null;
        Map<String, String> params = new HashMap<>(4);
        params.put("appid", appId);
        params.put("secret", appSecret);
        params.put("js_code", jsCode);
        params.put("grant_type", GRANT_TYPE);
        try {
            String res = HttpClientUtil.get(JS_CODE_TO_SESSION, params);
            WechatJsCode2SessionResult wechatJsCode2SessionResult = JsonUtils.parse(res, WechatJsCode2SessionResult.class);
            result = wechatJsCode2SessionResult.getSessionKey();
        } catch (ZiyiException e) {
            if (log.isDebugEnabled()) {
                log.debug("微信小程序获取sessionKey失败", e);
            }
        }
        return result;
    }
}
