/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class IdUtils {
    public static <T extends HasId<ID>, ID extends Serializable> Set<ID> getIds(Collection<T> col) {
        if (null == col) {
            return null;
        }
        return col.stream().filter(Objects::nonNull).map(HasId::getId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <T extends HasPid<ID>, ID extends Serializable> Set<ID> getPids(Collection<T> col) {
        if (null == col) {
            return null;
        }
        return col.stream().filter(Objects::nonNull).map(HasPid::getPid).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <T extends HasId<ID>, ID extends Serializable> Map<ID, T> getIdMap(Collection<T> col) {
        if (null == col) {
            return null;
        }
        return col.stream().collect(Collectors.toMap(HasId::getId, it -> it, (v1, v2) -> v1));
    }

    public static <T extends HasPid<ID>, ID extends Serializable> Map<ID, T> getPidMap(Collection<T> col) {
        if (null == col) {
            return null;
        }
        return col.stream().collect(Collectors.toMap(HasPid::getPid, it -> it, (v1, v2) -> v1));
    }

    public static <T extends HasId<ID>, ID extends Serializable> List<T> distinctById(Collection<T> col) {
        return col.stream().filter(IdUtils.distinctByKey(HasId::getId)).collect(Collectors.toList());
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap(20);
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static interface HasPid<ID extends Serializable> {
        public ID getPid();
    }

    public static interface HasId<ID extends Serializable> {
        public ID getId();
    }
}

