/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util;

import java.util.UUID;

public class UUIDUtils {
    private UUIDUtils() {
    }

    public static String getId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getId16() {
        return UUIDUtils.addZeroForNum(Long.toHexString(UUIDUtils.hash64(UUID.randomUUID().toString())), 16);
    }

    public static String createId(String clusterId, String type) {
        return UUIDUtils.formatStr(clusterId, 10) + UUIDUtils.formatStr(type, 6) + UUIDUtils.getId16();
    }

    public static String formatStr(String source, int length) {
        if (length <= 0) {
            return source;
        }
        StringBuilder result = new StringBuilder();
        int strLength = source.length();
        if (strLength > length) {
            result.append(source, 0, length);
        } else {
            result.append(source);
            int sub = length - strLength;
            for (int i = 0; i < sub; ++i) {
                result.append("0");
            }
        }
        return result.toString();
    }

    private static String addZeroForNum(String source, int length) {
        int strLen = source.length();
        if (strLen < length) {
            StringBuilder sourceBuilder = new StringBuilder(source);
            while (strLen < length) {
                sourceBuilder.insert(0, "0");
                strLen = sourceBuilder.length();
            }
            source = sourceBuilder.toString();
        }
        return source;
    }

    private static long hash64(String src) {
        long h = 1125899906842597L;
        int len = src.length();
        for (int i = 0; i < len; ++i) {
            h = 31L * h + (long)src.charAt(i);
        }
        return h;
    }
}

