/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.math;

public class DistanceUtils {
    private static final double EARTH_RADIUS = 6378137.0;

    private DistanceUtils() {
    }

    private static double toRadian(double angle) {
        return angle * Math.PI / 180.0;
    }

    public static double getDistance(double longitudeA, double latitudeA, double longitudeB, double latitudeB) {
        double latA = DistanceUtils.toRadian(latitudeA);
        double latB = DistanceUtils.toRadian(latitudeB);
        double longitudeDistanse = DistanceUtils.toRadian(longitudeA) - DistanceUtils.toRadian(longitudeB);
        double latitudeDistanse = latA - latB;
        double sinLongDis = Math.sin(longitudeDistanse / 2.0);
        double sinLatDis = Math.sin(latitudeDistanse / 2.0);
        double distanse = 1.2756274E7 * Math.asin(Math.sqrt(Math.pow(sinLatDis, 2.0) + Math.cos(latA) * Math.cos(latB) * Math.pow(sinLongDis, 2.0)));
        return distanse;
    }
}

