/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util.reflect;

import cn.ziyicloud.framework.boot.util.string.CamelCaseConversion;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.function.Predicate;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class ReflectUtils {
    private ReflectUtils() {
    }

    private static Reflections initReflections(String scannerPackage) {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.setScanners(new Scanner[]{Scanners.TypesAnnotated, Scanners.SubTypes});
        configurationBuilder.filterInputsBy((Predicate)new FilterBuilder().includePackage(scannerPackage));
        configurationBuilder.addUrls(ClasspathHelper.forPackage((String)scannerPackage, (ClassLoader[])new ClassLoader[0]));
        return new Reflections(scannerPackage, new Scanner[0]);
    }

    public static Collection<?> getSubClassList(String scannerPackage, Class<?> clazz) {
        return ReflectUtils.initReflections(scannerPackage).getSubTypesOf(clazz);
    }

    public static Field getField(Object object, String name) throws NoSuchFieldException {
        Field field;
        try {
            field = object.getClass().getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            name = CamelCaseConversion.toCamelCase(name);
            field = object.getClass().getDeclaredField(name);
        }
        return field;
    }
}

