package cn.ziyicloud.framework.boot.exception;

import cn.ziyicloud.framework.boot.enums.ErrorCodeEnum;
import lombok.Getter;
import lombok.ToString;

/**
 * Ziyi Exception
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.0
 */
@Getter
@ToString
public class BaseException extends RuntimeException {
    /**
     * 代码
     */
    private final int code;

    public BaseException() {
        super(ErrorCodeEnum.SERVER_ERROR.getMessage());
        this.code = ErrorCodeEnum.SERVER_ERROR.getCode();
    }

    public BaseException(String message) {
        super(message);
        this.code = ErrorCodeEnum.SERVER_ERROR.getCode();
    }


    public BaseException(String message, Throwable cause) {
        super(message, cause);
        this.code = ErrorCodeEnum.SERVER_ERROR.getCode();
    }

    public BaseException(Throwable cause) {
        super(cause);
        this.code = ErrorCodeEnum.SERVER_ERROR.getCode();
    }

    public BaseException(int code, String message) {
        super(message);
        this.code = code;
    }

    public BaseException(int code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    public BaseException(int code, Throwable cause) {
        super(cause);
        this.code = code;
    }

    public BaseException(ErrorCodeEnum errorCode) {
        super(errorCode.getMessage());
        this.code = errorCode.getCode();
    }

    public BaseException(ErrorCodeEnum errorCode, String message) {
        super(message);
        this.code = errorCode.getCode();
    }

    public BaseException(ErrorCodeEnum errorCode, String message, Throwable cause) {
        super(message, cause);
        this.code = errorCode.getCode();
    }

    public BaseException(ErrorCodeEnum errorCode, Throwable cause) {
        super(errorCode.getMessage(), cause);
        this.code = errorCode.getCode();
    }
}
