package cn.ziyicloud.framework.boot.mapper;

import java.util.List;
import java.util.Set;

/**
 * Entity 与DTO互换
 *
 * @author Li Ruitong 86415270@qq.com
 */
public interface BaseEntityMapper<D, E> {
    /**
     * DTO转Entity
     *
     * @param dto dto
     * @return entity
     */
    E toEntity(D dto);

    /**
     * Entity转DTO
     *
     * @param entity entity
     * @return dto
     */
    D toDto(E entity);

    /**
     * DTO集合转Entity集合
     *
     * @param dtoList dto list
     * @return entity list
     */
    List<E> toEntity(List<D> dtoList);

    /**
     * Entity集合转DTO集合
     *
     * @param entityList entity list
     * @return dto list
     */
    List<D> toDto(List<E> entityList);

    /**
     * DTO集合转Entity集合
     *
     * @param dtoSet dto set
     * @return entity set
     */
    Set<E> toEntity(Set<D> dtoSet);

    /**
     * Entity集合转DTO集合
     *
     * @param entitySet entity set
     * @return dto set
     */
    Set<D> toDto(Set<E> entitySet);
}
