package cn.ziyicloud.framework.boot.model;

import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 分页响应数据
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.7
 */
@Setter
@Getter
public class BasePageResponse<T> extends BaseResponse {
    /**
     * 数据
     */
    private List<T> data;
    /**
     * 总计
     */
    private Long total;

    public BasePageResponse() {
        super();
    }

    public BasePageResponse(List<T> data, long total) {
        super();
        this.data = data;
        this.total = total;
    }

    /**
     * 数据
     *
     * @param data 数据
     * @return {@link BasePageResponse}
     */
    public BasePageResponse data(List<T> data) {
        this.data = data;
        return this;
    }

    /**
     * 总计
     *
     * @param total 总计
     * @return {@link BasePageResponse}
     */
    public BasePageResponse total(Long total) {
        this.total = total;
        return this;
    }

}
