package cn.ziyicloud.framework.boot.model;

import cn.ziyicloud.framework.boot.enums.ErrorCodeEnum;
import cn.ziyicloud.framework.boot.exception.BaseException;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 统一返回前端数据的超类
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.7
 */
@Getter
@Setter
@ToString
public class BaseResponse {
    /**
     * 响应代码
     */
    private Integer code;
    /**
     * 响应信息
     */
    private String message;

    public BaseResponse() {
        this.code = ErrorCodeEnum.SUCCESS.getCode();
        this.message = ErrorCodeEnum.SUCCESS.getMessage();
    }

    public BaseResponse(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public BaseResponse(ErrorCodeEnum errorCode) {
        this.code = errorCode.getCode();
        this.message = errorCode.getMessage();
    }

    public BaseResponse(ErrorCodeEnum errorCode, String message) {
        this.code = errorCode.getCode();
        this.message = message;
    }

    public BaseResponse(BaseException e) {
        this.code = e.getCode();
        this.message = e.getMessage();
    }

    public BaseResponse(BaseException e, String message) {
        this.code = e.getCode();
        this.message = message;
    }

    /**
     * 请求是否通过
     *
     * @return true通过
     */
    public boolean valid() {
        return (0 == this.code);
    }

    /**
     * 代码
     *
     * @param code 代码
     * @return {@link BaseResponse}
     */
    public BaseResponse code(int code) {
        this.code = code;
        return this;
    }

    /**
     * 消息
     *
     * @param message 消息
     * @return {@link BaseResponse}
     */
    public BaseResponse message(String message) {
        this.message = message;
        return this;
    }
}
