package cn.ziyicloud.framework.boot.util;

import java.util.*;
import java.util.stream.Collectors;

import static cn.ziyicloud.framework.boot.util.conlection.CollectionUtils.distinctByKey;

/**
 * id工具类
 *
 * @author Li Ruitong 86415270@qq.com
 * @version 1.0
 * @since 1.0.0
 */
public class ObjectUtils {
    /**
     * 从对象集合中获取对象的id列表
     *
     * @param col  要获取id列表的对象集合
     * @param <T>  对象类型
     * @param <ID> id类型
     * @return id列表
     */
    public static <T extends HasId<ID>, ID> Set<ID> getIds(Collection<T> col) {
        if (null == col) {
            return null;
        }
        return col.stream().filter(Objects::nonNull).map(T::getId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    /**
     * 从对象集合中获取对象的id列表
     *
     * @param col  要获取id列表的对象集合
     * @param <T>  对象类型
     * @param <ID> id类型
     * @return id列表
     */
    public static <T extends HasPid<ID>, ID> Set<ID> getPids(Collection<T> col) {
        if (null == col) {
            return null;
        }
        return col.stream().filter(Objects::nonNull).map(T::getPid).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    /**
     * 对象集合转map
     *
     * @param col  要获取id列表的对象集合
     * @param <T>  对象类型
     * @param <ID> id类型
     * @return idMap
     */
    public static <T extends HasId<ID>, ID> Map<ID, T> getIdMap(Collection<T> col) {
        if (null == col) {
            return null;
        }
        return col.stream().collect(Collectors.toMap(T::getId,it->it,(v1,v2)->v1));
    }

    /**
     * 对象集合转map
     *
     * @param col  要获取id列表的对象集合
     * @param <T>  对象类型
     * @param <ID> id类型
     * @return idMap
     */
    public static <T extends HasPid<ID>, ID> Map<ID, T> getPidMap(Collection<T> col) {
        if (null == col) {
            return null;
        }
        return col.stream().collect(Collectors.toMap(T::getPid,it->it,(v1,v2)->v1));
    }

    /**
     * 想要用IdUtils工具简化获取id代码就要实现该接口
     *
     * @author Li Ruitong 86415270@qq.com
     * @version 1.0
     * @since 1.0.0
     */
    public interface HasId<ID> {
        /**
         * 获取id
         *
         * @return ID
         */
        ID getId();
    }

    /**
     * 想要用IdUtils工具简化获取pid代码就要实现该接口
     *
     * @author Li Ruitong 86415270@qq.com
     * @version 1.0
     * @since 1.0.0
     */
    public interface HasPid<ID> {
        /**
         * 获取id
         *
         * @return ID
         */
        ID getPid();
    }

    /**
     * 从对象集合中获取对象的id列表
     *
     * @param col  要获取id列表的对象集合
     * @param <T>  对象类型
     * @param <ID> id类型
     * @return id列表
     */
    public static <T extends HasId<ID>, ID> List<T> distinctById(Collection<T> col) {
        return col.stream().filter(distinctByKey(HasId::getId)).collect(Collectors.toList());
    }


}
