package cn.ziyicloud.framework.boot.util;

import java.util.UUID;

/**
 * UUID工具类
 *
 * @author Li Ruitong 86415270@qq.com
 */
public class UUIDUtils {
    private UUIDUtils() {
    }

    /**
     * 获取32位uuid值 不带-
     *
     * @return java.lang.String 返回32位uuid字符串值
     */
    public static String getId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    /**
     * 获取16位uuid值
     *
     * @return java.lang.String 返回16位uuid字符串值
     */
    public static String getId16() {
        return addZeroForNum(Long.toHexString(hash64(UUID.randomUUID().toString())), 16);
    }


    /**
     * 创建记录id
     *
     * @param clusterId 集群
     * @param type      记录类型
     * @return 创建后的id字符串
     */
    public static String createId(String clusterId, String type) {
        return formatStr(clusterId, 10) +
            formatStr(type, 6) +
            getId16();
    }

    /**
     * 截取指定长度字符串，不够位数补0
     *
     * @param source 原字符串
     * @param length 要截取的长度
     * @return java.lang.String 返回截取后的字符串
     */
    public static String formatStr(String source, int length) {
        if (length <= 0) {
            return source;
        }
        StringBuilder result = new StringBuilder();
        int strLength = source.length();
        if (strLength > length) {
            result.append(source, 0, length);
        } else {
            result.append(source);
            int sub = length - strLength;
            for (int i = 0; i < sub; i++) {
                result.append("0");
            }
        }
        return result.toString();
    }

    /**
     * 指定长度字符串，如字符串长度不够，补0
     *
     * @param source 原字符串
     * @param length 需要长度
     * @return java.lang.String
     */
    private static String addZeroForNum(String source, int length) {
        int strLen = source.length();
        if (strLen < length) {
            StringBuilder sourceBuilder = new StringBuilder(source);
            while (strLen < length) {
                sourceBuilder.insert(0, "0");
                strLen = sourceBuilder.length();
            }
            source = sourceBuilder.toString();
        }
        return source;
    }

    /**
     * hash64算法
     *
     * @param src 字符串
     * @return long
     */
    private static long hash64(String src) {
        // prime
        long h = 1125899906842597L;
        int len = src.length();

        for (int i = 0; i < len; i++) {
            h = 31 * h + src.charAt(i);
        }
        return h;
    }
}
