package cn.ziyicloud.framework.boot.util.exception;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * Exception Stack Trace utils
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.0
 */
public class StackTrackUtils {
    private StackTrackUtils() {
    }

    /**
     * Get Exception Stack Trace
     *
     * @param throwable Exception Instance
     * @return Stack Trace
     */
    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw)) {
            throwable.printStackTrace(pw);
            return sw.toString();
        }
    }
}
