package cn.ziyicloud.framework.boot.util.io;


import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * 文件工具类
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.0
 */
public class FileUtils {
    private FileUtils() {
    }

    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    /**
     * 文件转为二进制数组
     *
     * @param file 要转换的文件
     * @return 文件的二进制数组
     */
    public static byte[] fileToBinArray(File file) {
        byte[] bytes = null;
        try (InputStream fis = new FileInputStream(file)) {
            bytes = IOUtils.toByteArray(fis);
        } catch (IOException e) {
            log.info("文件转二进制数组出错", e);
        }
        return bytes;
    }

    /**
     * 网络文件转二进制数组
     *
     * @param fileUrlPath 文件网络地十
     * @return 网络文件的二进制数组
     */
    public static byte[] urlFileToBinArray(String fileUrlPath) {
        byte[] bytes = null;
        try {
            URL url = new URL(fileUrlPath);
            HttpURLConnection httpConn = (HttpURLConnection) url.openConnection();
            httpConn.connect();
            InputStream is = httpConn.getInputStream();
            bytes = IOUtils.toByteArray(is);
        } catch (IOException e) {
            log.info("网络文件转二进制数组出错", e);
        }
        return bytes;
    }

    /**
     * inputStream 转 File
     *
     * @param inputStream 输入流
     * @param filename    文件
     * @return 文件
     * @throws IOException IO 异常
     */
    public static File inputStreamToFile(InputStream inputStream, String filename) throws IOException {
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + filename);
        if (file.exists()) {
            return file;
        }
        OutputStream os = new FileOutputStream(file);
        IOUtils.copy(inputStream, os);
        return file;
    }
}
