package cn.ziyicloud.framework.boot.util.math;

/**
 * 距离相关操作工具类
 *
 * @author Li Ruitong 86415270@qq.com
 */
public class DistanceUtils {
    private DistanceUtils() {
    }

    /**
     * 赤道半径，单位m
     */
    private static final double EARTH_RADIUS = 6378137.0;

    /**
     * 角度转换为弧度
     *
     * @param angle 角度值
     * @return double 返回转换后的弧度值
     */
    private static double toRadian(double angle) {
        return angle * Math.PI / 180.0;
    }

    /**
     * 根据两点经纬度计算两点间距离
     *
     * @param longitudeA A点精度
     * @param latitudeA  A点纬度
     * @param longitudeB B点精度
     * @param latitudeB  B点纬度
     * @return double
     */
    public static double getDistance(double longitudeA, double latitudeA, double longitudeB, double latitudeB) {
        double distanse, longitudeDistanse, latitudeDistanse, latA, latB, sinLongDis, sinLatDis;
        //两点纬度-弧度值
        latA = toRadian(latitudeA);
        latB = toRadian(latitudeB);
        //两点经度之差
        longitudeDistanse = toRadian(longitudeA) - toRadian(longitudeB);
        //两点纬度之差
        latitudeDistanse = latA - latB;
        //经纬度差的正弦值
        sinLongDis = Math.sin(longitudeDistanse / 2.0);
        sinLatDis = Math.sin(latitudeDistanse / 2.0);

        distanse = 2 * EARTH_RADIUS
            * Math.asin(Math.sqrt(Math.pow(sinLatDis, 2) + Math.cos(latA) * Math.cos(latB) * Math.pow(sinLongDis, 2)));
        return distanse;
    }
}
