package cn.ziyicloud.framework.boot.util.math;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;

/**
 * 数学算法工具类
 *
 * @author Li Ruitong 86415270@qq.com
 */
public class MathUtils {
    private MathUtils() {
    }

    /**
     * 求最小公倍数
     *
     * @param list 要求最小公倍数的列表
     * @return 最小公倍数
     */
    public static int getLCM(List<Integer> list) {
        int max = Collections.max(list);
        for (int i = max; ; i++) {
            boolean flag = true;
            for (Integer integer : list) {
                if (max % integer != 0) {
                    flag = false;
                    break;
                }
            }
            max++;
            if (flag) {
                return i;
            }
        }
    }

    /**
     * 获取start-end间随即数
     *
     * @param start 开始
     * @param end   结束
     * @return 返回随即数
     */
    public static int random(int start, int end) {
        return (int) (Math.random() * (end - start + 1) + start);
    }

    /**
     * 获取start-end间随即数
     *
     * @param start 开始
     * @param end   结束
     * @return 返回随机数-保留两位小数
     */
    public static double randomDouble(int start, int end) {
        DecimalFormat df = new DecimalFormat("#.00");
        return Double.parseDouble(df.format(Math.random() * (end - start + 1) + start));
    }

    public static long factorial(long number) {
        if (number <= 1L) {
            return 1L;
        }
        return number * factorial(number - 1);
    }

}
