package cn.ziyicloud.framework.boot.util.reflect;

import cn.ziyicloud.framework.boot.util.string.CamelCaseConversion;
import org.reflections.Reflections;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

import java.lang.reflect.Field;
import java.util.Collection;

/**
 * class 工具类
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.0
 */
public class ReflectUtils {
    private ReflectUtils() {
    }

    /**
     * 初始化反射对象
     *
     * @param scannerPackage 扫描的package
     * @return 反射对象
     */
    private static Reflections initReflections(String scannerPackage) {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.setScanners(Scanners.TypesAnnotated, Scanners.SubTypes);
        configurationBuilder.filterInputsBy(new FilterBuilder().includePackage(scannerPackage));
        configurationBuilder.addUrls(ClasspathHelper.forPackage(scannerPackage));
        return new Reflections(scannerPackage);
    }

    /**
     * 获取指定package下的接口实现类
     *
     * @param scannerPackage 扫描的package
     * @param clazz          clazz
     * @return 实现类集合
     */
    public static Collection<?> getSubClassList(String scannerPackage, Class<?> clazz) {
        return initReflections(scannerPackage).getSubTypesOf(clazz);
    }

    /**
     * 通过反射区域对象的Field
     *
     * @param object 对象
     * @param name   属性名
     * @return Field
     * @throws NoSuchFieldException NoSuchFieldException
     */
    public static Field getField(Object object, String name) throws NoSuchFieldException {
        Field field;
        try {
            field = object.getClass().getDeclaredField(name);
        } catch (NoSuchFieldException e) {
            //转为驼峰式
            name = CamelCaseConversion.toCamelCase(name);
            field = object.getClass().getDeclaredField(name);
        }
        return field;
    }
}
