package cn.ziyicloud.framework.boot.util.string;

/**
 * 驼峰字符串转换工具类
 *
 * @author Li Ruitong 86415270@qq.com
 */
public class CamelCaseConversion {
    private static final String EMPTY = "";
    private static final String SPACE_CASE_SEPARATOR = " ";
    private static final String SNAKE_CASE_SEPARATOR = "_";
    private static final String KEBAB_CASE_SEPARATOR = "-";

    private CamelCaseConversion() {
    }


    /**
     * 转换成snake_case格式字符串
     *
     * @param in 输入字符串
     * @return toSnakeCase(" helloWorld ")=="hello_world"
     */
    public static String toSnakeCase(String in) {
        if (in == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(EMPTY + Character.toLowerCase(in.charAt(0)));
        for (int i = 1; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append(SNAKE_CASE_SEPARATOR).append(Character.toLowerCase(c));
            } else {
                result.append(c);
            }
        }
        return result.toString();
    }

    /**
     * 转换成SNAKE_CASE格式字符串
     *
     * @param in 输入字符串
     * @return toSnakeCase(" helloWorld ")=="HELLO_WORLD"
     */
    public static String toUpperSnakeCase(String in) {
        return toSnakeCase(in).toUpperCase();
    }

    /**
     * 转换成kebab-case格式字符串
     *
     * @param in 输入字符串
     * @return toKebabCase(" helloWorld ")=="hello-world"
     */
    public static String toKebabCase(String in) {
        String snakeCased = toSnakeCase(in);
        return snakeCased.replace(SNAKE_CASE_SEPARATOR, KEBAB_CASE_SEPARATOR);
    }

    /**
     * 转换成snake_case格式字符串
     *
     * @param in 输入字符串
     * @return toSpaceCase(" helloWorld ")=="hello world"
     */
    public static String toSpaceCase(String in) {
        String snakeCased = toSnakeCase(in);
        return snakeCased.replace(SNAKE_CASE_SEPARATOR, SPACE_CASE_SEPARATOR);
    }


    /**
     * 转换成PascalCase格式字符串
     *
     * @param in 输入字符串
     * @return toPascalCase(" hello_world ")=="HelloWorld"
     */
    public static String toPascalCase(String in) {
        if (in == null) {
            return null;
        }
        StringBuilder pascalCase = new StringBuilder();
        String[] tokens = in.split("_");
        int var4 = tokens.length;

        for (String token : tokens) {
            if (token.length() >= 1) {
                pascalCase.append(token.substring(0, 1).toUpperCase()).append(token.substring(1));
            } else {
                pascalCase.append("_");
            }
        }

        return pascalCase.toString();
    }

    /**
     * 转换成camelCase格式字符串
     *
     * @param in 输入字符串
     * @return toCamelCase(" hello_world ")=="helloWorld"
     */
    public static String toCamelCase(String in) {
        String pascalCase = toPascalCase(in);
        return pascalCase.substring(0, 1).toLowerCase() + pascalCase.substring(1);
    }
}
