package cn.ziyicloud.framework.boot.util.wx;

import lombok.Data;

/**
 * 微信用户信息
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.0
 */
@Data
public class WechatUserInfo {


    /**
     * openId
     */
    private String openId;
    /**
     * 昵称
     */
    private String nickName;
    /**
     * 性别0未知1男2女
     */
    private int gender;
    /**
     * 语言
     */
    private String language;
    /**
     * 城市
     */
    private String city;
    /**
     * 省份
     */
    private String province;
    /**
     * 国家
     */
    private String country;
    /**
     * 头像地址
     */
    private String avatarUrl;
    /**
     * unionId
     */
    private String unionId;
    /**
     * 验证信息
     */
    private Watermark watermark;

    @Data
    public static class Watermark {
        /**
         * 时间戳
         */
        private int timestamp;
        /**
         * appid
         */
        private String appid;
    }
}
