/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.util;

import cn.ziyicloud.framework.boot.util.conlection.CollectionUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ObjectUtils {
    public static <T extends HasId<ID>, ID> Set<ID> getIds(Collection<T> col) {
        if (null == col) {
            return null;
        }
        return col.stream().filter(Objects::nonNull).map(HasId::getId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <T extends HasPid<ID>, ID> Set<ID> getPids(Collection<T> col) {
        if (null == col) {
            return null;
        }
        return col.stream().filter(Objects::nonNull).map(HasPid::getPid).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <T extends HasId<ID>, ID> Map<ID, T> getIdMap(Collection<T> col) {
        if (null == col) {
            return null;
        }
        return col.stream().collect(Collectors.toMap(HasId::getId, it -> it, (v1, v2) -> v1));
    }

    public static <T extends HasPid<ID>, ID> Map<ID, T> getPidMap(Collection<T> col) {
        if (null == col) {
            return null;
        }
        return col.stream().collect(Collectors.toMap(HasPid::getPid, it -> it, (v1, v2) -> v1));
    }

    public static <T extends HasId<ID>, ID> List<T> distinctById(Collection<T> col) {
        return col.stream().filter(CollectionUtils.distinctByKey(HasId::getId)).collect(Collectors.toList());
    }

    public static interface HasPid<ID> {
        public ID getPid();
    }

    public static interface HasId<ID> {
        public ID getId();
    }
}

